<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class TipoEstado extends Model
{
    protected $table = 'tipos_estado';

    protected $fillable = [
        'modulo_id',
        'nombre',
        'slug',
        'icono',
        'orden',
        'activo',
    ];

    protected $casts = [
        'activo' => 'boolean',
    ];

    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($tipoEstado) {
            if (empty($tipoEstado->slug)) {
                $tipoEstado->slug = Str::slug($tipoEstado->nombre);
            }
        });
        
        static::updating(function ($tipoEstado) {
            if ($tipoEstado->isDirty('nombre') && empty($tipoEstado->slug)) {
                $tipoEstado->slug = Str::slug($tipoEstado->nombre);
            }
        });
    }

    public function modulo(): BelongsTo
    {
        return $this->belongsTo(Modulo::class);
    }

    public function estados(): HasMany
    {
        return $this->hasMany(Estado::class)->orderBy('orden');
    }
}
