<x-filament-panels::page>
    {{-- CDN para Select2 --}}
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <style>
        .select2-container--default .select2-selection--multiple {
            min-height: 42px;
            border: 1px solid #d1d5db;
            border-radius: 0.5rem;
            padding: 0.25rem;
        }
        .select2-container--default.select2-container--focus .select2-selection--multiple {
            border-color: #3b82f6;
            outline: none;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }
        .select2-container {
            width: 100% !important;
        }
        .select2-dropdown {
            border-radius: 0.5rem;
            border-color: #d1d5db;
        }
    </style>

    <div class="space-y-6">
        {{-- Header --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">
                📊 Reporte de Control Mensual
            </h2>
            <p class="text-gray-600 dark:text-gray-400">
                Selecciona los filtros y genera reportes personalizados en Excel o PDF.
            </p>
        </div>

        {{-- Formulario de Filtros --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <form method="GET" action="{{ route('filament.admin.resources.reporte-control-mensuals.export') }}" 
                  id="reporteForm"
                  class="space-y-6">
                @csrf
                
                {{-- Grid: Año (pequeño) + Periodo (mediano) + Cliente (grande) --}}
                <div class="grid grid-cols-12 gap-4">
                    
                    {{-- Filtro Año - 2 columnas --}}
                    <div class="col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            Año(s) <span class="text-red-500">*</span>
                        </label>
                        <select name="anios[]" id="select-anios" multiple class="w-full" required>
                            @foreach($aniosDisponibles as $anio)
                                <option value="{{ $anio }}">{{ $anio }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Filtro Periodo - 3 columnas --}}
                    <div class="col-span-3">
                        <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            Periodo(s) <span class="text-red-500">*</span>
                        </label>
                        <select name="periodos[]" id="select-periodos" multiple class="w-full" required>
                            @foreach($periodosDisponibles as $periodo)
                                <option value="{{ $periodo }}">{{ $periodo }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Filtro Clientes - 7 columnas --}}
                    <div class="col-span-7">
                        <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            Cliente(s) <span class="text-red-500">*</span>
                        </label>
                        <select name="clientes[]" id="select-clientes" multiple class="w-full" required>
                            @foreach($clientesDisponibles as $cliente)
                                <option value="{{ $cliente->id }}">{{ $cliente->nombre_empresa }} ({{ $cliente->rut_empresa }})</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                {{-- Botones de Exportación --}}
                <div class="flex flex-wrap gap-4 pt-6 border-t border-gray-200 dark:border-gray-700">
                    <button type="submit" name="formato" value="excel"
                            class="inline-flex items-center justify-center px-8 py-3 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Descargar Excel
                    </button>

                    <button type="submit" name="formato" value="pdf"
                            class="inline-flex items-center justify-center px-8 py-3 bg-red-600 hover:bg-red-700 text-white font-semibold rounded-lg transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                        </svg>
                        Descargar PDF
                    </button>
                </div>
            </form>
        </div>

        {{-- Información --}}
        <div class="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-4 border border-blue-200 dark:border-blue-800">
            <div class="flex items-start">
                <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div class="text-sm text-blue-800 dark:text-blue-300">
                    <p class="font-semibold mb-2">Información del reporte:</p>
                    <ul class="list-disc list-inside space-y-1">
                        <li>El archivo Excel incluirá todos los campos del Control Mensual</li>
                        <li>El nombre incluirá fecha y hora de generación</li>
                        <li>Compatible con Excel, Google Sheets y LibreOffice</li>
                        <li>La exportación a PDF está en desarrollo</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    {{-- Inicializar Select2 --}}
    <script>
        $(document).ready(function() {
            $('#select-anios').select2({
                placeholder: 'Selecciona año(s)',
                allowClear: true,
                width: '100%'
            });

            $('#select-periodos').select2({
                placeholder: 'Selecciona periodo(s)',
                allowClear: true,
                width: '100%'
            });

            $('#select-clientes').select2({
                placeholder: 'Selecciona cliente(s)',
                allowClear: true,
                width: '100%'
            });
        });
    </script>

    @if(session('success'))
        <div x-data="{ show: true }" 
             x-show="show" 
             x-init="setTimeout(() => show = false, 5000)"
             x-transition
             class="fixed bottom-4 right-4 bg-green-500 text-white px-6 py-4 rounded-lg shadow-2xl z-50 flex items-center max-w-md">
            <svg class="w-6 h-6 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            <span class="font-medium">{{ session('success') }}</span>
        </div>
    @endif
    
    @if(session('error'))
        <div x-data="{ show: true }" 
             x-show="show" 
             x-init="setTimeout(() => show = false, 5000)"
             x-transition
             class="fixed bottom-4 right-4 bg-red-500 text-white px-6 py-4 rounded-lg shadow-2xl z-50 flex items-center max-w-md">
            <svg class="w-6 h-6 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
            <span class="font-medium">{{ session('error') }}</span>
        </div>
    @endif
</x-filament-panels::page>
