<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('clientes', function (Blueprint $table) {
            $table->id();
            
            // Información básica
            $table->foreignId('grupo_empresa_id')->nullable()->constrained('grupos_empresa')->nullOnDelete();
            $table->string('nombre_empresa');
            $table->string('rut_empresa')->unique();
            
            // Representante
            $table->string('nombre_rep')->nullable();
            $table->string('rut_rep')->nullable();
            
            // Dirección
            $table->text('direccion_emp')->nullable();
            
            // Software principal
            $table->foreignId('software_id')->nullable()->constrained('softwares')->nullOnDelete();
            $table->string('nom_en_sw')->nullable()->comment('Nombre en el software');
            $table->string('usuario_sw_main')->nullable();
            $table->text('clave_sw_main')->nullable(); // Encriptado
            
            // SII
            $table->string('rut_sii')->nullable();
            $table->text('clave_sii')->nullable(); // Encriptado
            $table->text('clave_unica')->nullable(); // Encriptado
            
            // Previred
            $table->string('usuario_previred')->nullable();
            $table->text('clave_previred')->nullable(); // Encriptado
            
            // DT
            $table->text('clave_dt')->nullable(); // Encriptado
            
            // Defontana
            $table->string('usuario_defontana')->nullable();
            $table->text('clave_defontana')->nullable(); // Encriptado
            
            // Nubox
            $table->string('usuario_nubox')->nullable();
            $table->text('clave_nubox')->nullable(); // Encriptado
            
            // Banco
            $table->foreignId('banco_id')->nullable()->constrained('bancos')->nullOnDelete();
            $table->enum('tipo_ingreso_banco', ['web', 'api', 'archivo', 'manual'])->nullable();
            $table->string('usuario_banco')->nullable();
            $table->text('clave_us_banco')->nullable(); // Encriptado
            
            $table->boolean('activo')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('clientes');
    }
};
