<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoImposicionesPrevisionales;
use App\Filament\Resources\Estados\Pages\EditEstadoImposicionesPrevisionales;

class EstadoImposicionesPrevisionalesResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Imposiciones Previsionales';
    
    protected static ?string $navigationIcon = 'heroicon-o-building-library';
    
    protected static ?int $navigationSort = 11;
    
    protected static function tipo(): string
    {
        return 'imposiciones_previsionales';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoImposicionesPrevisionales::route('/'),
            'edit'  => EditEstadoImposicionesPrevisionales::route('/{record}/edit'),
        ];
    }
}
