<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoConciliacionBancaria;
use App\Filament\Resources\Estados\Pages\EditEstadoConciliacionBancaria;

class EstadoConciliacionBancariaResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Conciliación Bancaria';
    
    protected static ?string $navigationIcon = 'heroicon-o-banknotes';
    
    protected static ?int $navigationSort = 5;
    
    protected static function tipo(): string
    {
        return 'conciliacion_bancaria';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoConciliacionBancaria::route('/'),
            'edit'  => EditEstadoConciliacionBancaria::route('/{record}/edit'),
        ];
    }
}
