<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Crear tabla pivote para múltiples bancos por cliente
        Schema::create('banco_cliente', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cliente_id')->constrained('clientes')->cascadeOnDelete();
            $table->foreignId('banco_id')->constrained('bancos')->cascadeOnDelete();
            $table->string('numero_cuenta')->nullable();
            $table->enum('tipo_ingreso_banco', ['web', 'api', 'archivo', 'manual'])->nullable();
            $table->string('usuario_banco')->nullable();
            $table->text('clave_banco')->nullable(); // Encriptado
            $table->boolean('principal')->default(false); // Marcar el banco principal
            $table->timestamps();
            
            // Índice único para evitar duplicados
            $table->unique(['cliente_id', 'banco_id']);
        });
        
        // Migrar datos existentes de la tabla clientes a banco_cliente
        DB::statement('
            INSERT INTO banco_cliente (cliente_id, banco_id, numero_cuenta, tipo_ingreso_banco, usuario_banco, clave_banco, principal, created_at, updated_at)
            SELECT id, banco_id, NULL, tipo_ingreso_banco, usuario_banco, clave_us_banco, true, created_at, updated_at
            FROM clientes
            WHERE banco_id IS NOT NULL
        ');
        
        // Eliminar columnas antiguas de clientes
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropForeign(['banco_id']);
            $table->dropColumn(['banco_id', 'tipo_ingreso_banco', 'usuario_banco', 'clave_us_banco']);
        });
    }

    public function down(): void
    {
        // Restaurar columnas en clientes
        Schema::table('clientes', function (Blueprint $table) {
            $table->foreignId('banco_id')->nullable()->constrained('bancos')->nullOnDelete();
            $table->enum('tipo_ingreso_banco', ['web', 'api', 'archivo', 'manual'])->nullable();
            $table->string('usuario_banco')->nullable();
            $table->text('clave_us_banco')->nullable();
        });
        
        // Migrar datos de vuelta (solo el banco principal)
        DB::statement('
            UPDATE clientes c
            INNER JOIN banco_cliente bc ON c.id = bc.cliente_id AND bc.principal = true
            SET c.banco_id = bc.banco_id,
                c.tipo_ingreso_banco = bc.tipo_ingreso_banco,
                c.usuario_banco = bc.usuario_banco,
                c.clave_us_banco = bc.clave_banco
        ');
        
        Schema::dropIfExists('banco_cliente');
    }
};
