<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoLibroElectronicoRemuneraciones;
use App\Filament\Resources\Estados\Pages\EditEstadoLibroElectronicoRemuneraciones;

class EstadoLibroElectronicoRemuneracionesResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'LRE';
    
    protected static ?string $navigationIcon = 'heroicon-o-book-open';
    
    protected static ?int $navigationSort = 12;
    
    protected static function tipo(): string
    {
        return 'libro_electronico_remuneraciones';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoLibroElectronicoRemuneraciones::route('/'),
            'edit'  => EditEstadoLibroElectronicoRemuneraciones::route('/{record}/edit'),
        ];
    }
}
