<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('perfil_id')->nullable()->after('password')->constrained('perfiles')->onDelete('set null');
            $table->string('cargo', 100)->nullable()->after('perfil_id');
            $table->string('telefono', 20)->nullable()->after('cargo');
            $table->boolean('activo')->default(true)->after('telefono');
            $table->timestamp('ultimo_acceso')->nullable()->after('activo');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['perfil_id']);
            $table->dropColumn(['perfil_id', 'cargo', 'telefono', 'activo', 'ultimo_acceso']);
        });
    }
};
