<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('perfil_campo_permisos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perfil_id')->constrained('perfiles')->onDelete('cascade');
            $table->string('modulo', 100); // clientes, control_gestion_mensual, etc.
            $table->string('campo', 100); // nombre_empresa, rut_empresa, folio_cm, etc.
            $table->boolean('puede_ver')->default(false);
            $table->boolean('puede_editar')->default(false);
            $table->boolean('puede_crear')->default(false);
            $table->boolean('puede_eliminar')->default(false);
            $table->timestamps();
            
            $table->unique(['perfil_id', 'modulo', 'campo'], 'perfil_modulo_campo_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('perfil_campo_permisos');
    }
};
