<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('perfil_modulos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perfil_id')->constrained('perfiles')->onDelete('cascade');
            $table->string('modulo', 100); // clientes, maestro_control_mensual, etc.
            $table->boolean('tiene_acceso')->default(false);
            $table->boolean('puede_ver')->default(false);
            $table->boolean('puede_crear')->default(false);
            $table->boolean('puede_editar')->default(false);
            $table->boolean('puede_eliminar')->default(false);
            $table->timestamps();
            
            $table->unique(['perfil_id', 'modulo']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('perfil_modulos');
    }
};
