<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            // Información Básica - Socios
            $table->string('nombre_socio_1')->nullable()->after('activo');
            $table->string('rut_socio_1')->nullable()->after('nombre_socio_1');
            $table->string('nombre_socio_2')->nullable()->after('rut_socio_1');
            $table->string('rut_socio_2')->nullable()->after('nombre_socio_2');
            $table->string('nombre_socio_3')->nullable()->after('rut_socio_2');
            $table->string('rut_socio_3')->nullable()->after('nombre_socio_3');
            
            // Accesos SII - Información de Socios
            $table->string('rut_sii_socio_1')->nullable()->after('clave_dt');
            $table->text('clave_sii_socio_1')->nullable()->after('rut_sii_socio_1');
            $table->string('rut_sii_socio_2')->nullable()->after('clave_sii_socio_1');
            $table->text('clave_sii_socio_2')->nullable()->after('rut_sii_socio_2');
            $table->string('rut_sii_socio_3')->nullable()->after('clave_sii_socio_2');
            $table->text('clave_sii_socio_3')->nullable()->after('rut_sii_socio_3');
            
            // Otros campos tributarios
            $table->date('fecha_inicio_actividades')->nullable()->after('clave_sii_socio_3');
            $table->integer('anio_tributario')->nullable()->after('fecha_inicio_actividades');
            $table->foreignId('regimen_tributario_id')->nullable()->constrained('estados', indexName: 'clientes_regimen_trib_fk')->onDelete('set null')->after('anio_tributario');
        });
    }

    public function down(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropForeign('clientes_regimen_trib_fk');
            $table->dropColumn([
                'nombre_socio_1',
                'rut_socio_1',
                'nombre_socio_2',
                'rut_socio_2',
                'nombre_socio_3',
                'rut_socio_3',
                'rut_sii_socio_1',
                'clave_sii_socio_1',
                'rut_sii_socio_2',
                'clave_sii_socio_2',
                'rut_sii_socio_3',
                'clave_sii_socio_3',
                'fecha_inicio_actividades',
                'anio_tributario',
                'regimen_tributario_id',
            ]);
        });
    }
};
