<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('control_gestion_mensual', function (Blueprint $table) {
            // Índice único compuesto: cliente_id + periodo
            // Esto previene duplicados a nivel de base de datos
            $table->unique(['cliente_id', 'periodo'], 'unique_cliente_periodo');
        });
    }

    public function down(): void
    {
        Schema::table('control_gestion_mensual', function (Blueprint $table) {
            $table->dropUnique('unique_cliente_periodo');
        });
    }
};
