<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ControlGestionMensual extends Model
{
    use HasFactory;

    protected $table = 'control_gestion_mensual';

    protected $fillable = [
        'cliente_id',
        'grupo_empresa_id',
        'periodo',
        // Estados
        'compras_ventas_id',
        'formulario_29_id',
        'centralizacion_impuesto_id',
        'est_sueldos_id',
        'imposiciones_previsionales_id',
        'certificados_laborales_id',
        'libro_electronico_remuneraciones_id',
        'despidos_mes_id',
        'registro_electronico_dt_id',
        'archivo_dig_cont_anex_otros_id',
        'mora_presuntas_id',
        'deudas_fiscales_id',
        'conciliacion_bancaria_id',
        'balance_mensual_id',
        'analisis_cuentas_id',
        // Formulario 29
        'folio_cm',
        'monto_peso_cm',
        'fecha_venc_form29_cm',
        'fecha_declara_en_plazo_cm',
        'fecha_pago_f_p_cm',
        'multa_acum_clp_cm',
        'total_pagado_clp_cm',
        // IVA Posterior
        'iva_post_clp_cm',
        'fecha_venc_iva_post_cm',
        'fecha_pago_iva_post_cm',
        'multa_iva_post_clp_cm',
        // Horas
        'hh_compra_venta_iva_cm',
        'hh_impo_cm',
        'hh_deuda_cm',
        'hh_banco_balance_cm',
        'total_hh_mes_cm',
        'hh_asignada_mes',
        'diferencia_hh_mes_cm',
        // Imposiciones
        'monto_impo_cm',
        'fecha_venc_impo_cm',
        'fecha_pago_impo',
        'multa_impo_clp_cm',
        'total_pagado_clp_impo_cm',
        // Valores
        'valor_servicio_cm',
        'valor_hh_cm',
    ];

    protected $casts = [
        'monto_peso_cm' => 'decimal:0',
        'multa_acum_clp_cm' => 'decimal:0',
        'total_pagado_clp_cm' => 'decimal:0',
        'iva_post_clp_cm' => 'decimal:0',
        'multa_iva_post_clp_cm' => 'decimal:0',
        'monto_impo_cm' => 'decimal:0',
        'multa_impo_clp_cm' => 'decimal:0',
        'total_pagado_clp_impo_cm' => 'decimal:0',
    ];

    /**
     * Relación con Cliente
     */
    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class);
    }

    /**
     * Relación con Grupo de Empresa
     */
    public function grupoEmpresa(): BelongsTo
    {
        return $this->belongsTo(GrupoEmpresa::class);
    }

    /**
     * Relaciones con Estados (15 estados diferentes)
     */
    public function comprasVentas(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'compras_ventas_id');
    }

    public function formulario29(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'formulario_29_id');
    }

    public function centralizacionImpuesto(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'centralizacion_impuesto_id');
    }

    public function estSueldos(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'est_sueldos_id');
    }

    public function imposicionesPrevisionales(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'imposiciones_previsionales_id');
    }

    public function certificadosLaborales(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'certificados_laborales_id');
    }

    public function libroElectronicoRemuneraciones(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'libro_electronico_remuneraciones_id');
    }

    public function despidosMes(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'despidos_mes_id');
    }

    public function registroElectronicoDt(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'registro_electronico_dt_id');
    }

    public function archivoDigContAnexOtros(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'archivo_dig_cont_anex_otros_id');
    }

    public function moraPresuntas(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'mora_presuntas_id');
    }

    public function deudasFiscales(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'deudas_fiscales_id');
    }

    public function conciliacionBancaria(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'conciliacion_bancaria_id');
    }

    public function balanceMensual(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'balance_mensual_id');
    }

    public function analisisCuentas(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'analisis_cuentas_id');
    }

    /**
     * Accessor para obtener nombre de grupo
     */
    public function getNombreGrupoAttribute(): ?string
    {
        return $this->grupoEmpresa?->nombre;
    }

    /**
     * Accessor para obtener RUT de empresa
     */
    public function getRutEmpresaAttribute(): ?string
    {
        return $this->cliente?->rut_empresa;
    }

    /**
     * Accessor para obtener nombre de empresa
     */
    public function getNombreEmpresaAttribute(): ?string
    {
        return $this->cliente?->nombre_empresa;
    }
}
