<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ReporteControlMensualResource\Pages;
use App\Models\ReporteControlMensual;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Table;

class ReporteControlMensualResource extends Resource
{
    protected static ?string $model = ReporteControlMensual::class;

    protected static ?string $navigationIcon = 'heroicon-o-document-chart-bar';
    
    protected static ?string $navigationLabel = 'Reporte Control Mensual';
    
    protected static ?string $navigationGroup = 'Gestión';
    
    protected static ?int $navigationSort = 10;
    
    public static function shouldRegisterNavigation(): bool
    {
        $user = auth()->user();
        
        if (!$user || !$user->perfil) {
            return false;
        }
        
        // Super Admin siempre tiene acceso
        if ($user->perfil->nombre === 'Super Admin' || $user->perfil->nombre === 'Administrador') {
            return true;
        }
        
        return $user->tieneAccesoModulo('reportes_control_mensual');
    }
    
    protected static ?string $modelLabel = 'Reporte Control Mensual';
    
    protected static ?string $pluralModelLabel = 'Reportes Control Mensual';

    public static function form(Form $form): Form
    {
        return $form->schema([]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListReporteControlMensuals::route('/'),
        ];
    }
    
    // Deshabilitamos las acciones de crear/editar/eliminar ya que es solo un reporte
    public static function canCreate(): bool
    {
        return false;
    }
}
