<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('estados', function (Blueprint $table) {
            $table->id();
            $table->string('tipo');
            $table->string('nombre');
            $table->string('color')->default('gray');
            $table->integer('orden')->default(0);
            $table->boolean('activo')->default(true);
            $table->timestamps();
        });

        // Insertar estados iniciales
        $estados = [
            // ESTADO_COMPRAS_Y_VENTAS
            ['tipo' => 'compras_ventas', 'nombre' => 'Ingresado', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'compras_ventas', 'nombre' => 'No Ingresado', 'color' => 'danger', 'orden' => 2],
            ['tipo' => 'compras_ventas', 'nombre' => 'Sin Movimiento', 'color' => 'gray', 'orden' => 3],
            ['tipo' => 'compras_ventas', 'nombre' => 'Revisado', 'color' => 'success', 'orden' => 4],
            ['tipo' => 'compras_ventas', 'nombre' => 'No Revisado', 'color' => 'warning', 'orden' => 5],
            
            // ESTADO_FORMULARIO_29
            ['tipo' => 'formulario_29', 'nombre' => 'No calculado', 'color' => 'warning', 'orden' => 1],
            ['tipo' => 'formulario_29', 'nombre' => 'Guardado en SII', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'formulario_29', 'nombre' => 'Declarado', 'color' => 'info', 'orden' => 3],
            ['tipo' => 'formulario_29', 'nombre' => 'Declarado con Giro', 'color' => 'info', 'orden' => 4],
            ['tipo' => 'formulario_29', 'nombre' => 'No Declarado', 'color' => 'info', 'orden' => 5],
            
            // ESTADO_CENTRALIZACION_IMPUESTO
            ['tipo' => 'centralizacion_impuesto', 'nombre' => 'Centralizado', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'centralizacion_impuesto', 'nombre' => 'No Centralizado', 'color' => 'info', 'orden' => 2],
            ['tipo' => 'centralizacion_impuesto', 'nombre' => 'Sin Movimiento', 'color' => 'info', 'orden' => 3],
            
            // ESTADO_DEUDAS_FISCALES_INFORMADAS
            ['tipo' => 'deudas_fiscales', 'nombre' => 'Informadas', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'deudas_fiscales', 'nombre' => 'No Informadas', 'color' => 'info', 'orden' => 2],
            ['tipo' => 'deudas_fiscales', 'nombre' => 'No Aplica', 'color' => 'info', 'orden' => 3],
            
            // ESTADO_CONCILIACION_BANCARIA
            ['tipo' => 'conciliacion_bancaria', 'nombre' => 'Conciliada', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'conciliacion_bancaria', 'nombre' => 'Conciliada Parcial', 'color' => 'info', 'orden' => 2],
            ['tipo' => 'conciliacion_bancaria', 'nombre' => 'No Conciliada', 'color' => 'info', 'orden' => 3],
            ['tipo' => 'conciliacion_bancaria', 'nombre' => 'Revisada', 'color' => 'info', 'orden' => 4],
            ['tipo' => 'conciliacion_bancaria', 'nombre' => 'No Revisada', 'color' => 'info', 'orden' => 5],
            
            // ESTADO_BALANCE_MENSUAL
            ['tipo' => 'balance_mensual', 'nombre' => 'Emitido', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'balance_mensual', 'nombre' => 'No Emitido', 'color' => 'info', 'orden' => 2],
            ['tipo' => 'balance_mensual', 'nombre' => 'Revisado', 'color' => 'info', 'orden' => 3],
            ['tipo' => 'balance_mensual', 'nombre' => 'No Revisado', 'color' => 'info', 'orden' => 4],
            ['tipo' => 'balance_mensual', 'nombre' => 'No Aplica', 'color' => 'info', 'orden' => 5],
            
            // ANALISIS_DE_CUENTAS_Y_ESTADISTICAS_MENSUAL
            ['tipo' => 'analisis_cuentas', 'nombre' => 'Realizado', 'color' => 'info', 'orden' => 1],
            ['tipo' => 'analisis_cuentas', 'nombre' => 'No Realizado', 'color' => 'info', 'orden' => 2],
            
            // ESTADO_MORA_PRESUNTAS
            ['tipo' => 'mora_presuntas', 'nombre' => 'Con Moras Presuntas', 'color' => 'info', 'orden' => 1],
            ['tipo' => 'mora_presuntas', 'nombre' => 'Sin Moras Presuntas', 'color' => 'info', 'orden' => 2],
            ['tipo' => 'mora_presuntas', 'nombre' => 'No Aplica', 'color' => 'info', 'orden' => 3],

            //ESTADO_SUELDOS
            ['tipo' => 'est_sueldos', 'nombre' => 'Calculados', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'est_sueldos', 'nombre' => 'No Calculados', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'est_sueldos', 'nombre' => 'Revisados', 'color' => 'success', 'orden' => 3],
            ['tipo' => 'est_sueldos', 'nombre' => 'No Revisados', 'color' => 'success', 'orden' => 4],
            ['tipo' => 'est_sueldos', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 5],

            //ESTADO_CERTIFICADOS_LABORALES
            ['tipo' => 'certificados_laborales', 'nombre' => 'Emitidos', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'certificados_laborales', 'nombre' => 'No Emitidos', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'certificados_laborales', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 3],

            //ESTADO_IMPOSICIONES_PREVISIONALES
            ['tipo' => 'imposiciones_previsionales', 'nombre' => 'Cargadas en Previred', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'imposiciones_previsionales', 'nombre' => 'No Cargadas en Previred', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'imposiciones_previsionales', 'nombre' => 'Declaradas con Pago', 'color' => 'success', 'orden' => 3],
            ['tipo' => 'imposiciones_previsionales', 'nombre' => 'Declaradas Sin Pago', 'color' => 'success', 'orden' => 4],
            ['tipo' => 'imposiciones_previsionales', 'nombre' => 'No Declaradas', 'color' => 'success', 'orden' => 5],
            ['tipo' => 'imposiciones_previsionales', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 6],

            //ESTADO_LRE 
            ['tipo' => 'libro_electronico_remuneraciones', 'nombre' => 'Declarado', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'libro_electronico_remuneraciones', 'nombre' => 'No Declarado', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'libro_electronico_remuneraciones', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 3],

            //ESTADO_DESPIDOS_MES
            ['tipo' => 'despidos_mes', 'nombre' => 'Con despidos', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'despidos_mes', 'nombre' => 'Sin despidos', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'despidos_mes', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 3],

            //ESTADO_REGISTRO_ELECTRONICO_DT
            ['tipo' => 'registro_electronico_dt', 'nombre' => 'Actualizado', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'registro_electronico_dt', 'nombre' => 'No Actualizado', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'registro_electronico_dt', 'nombre' => 'Sin Movimiento', 'color' => 'success', 'orden' => 3],
            ['tipo' => 'registro_electronico_dt', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 4],

            //ESTADO_ARCHIVO_DIGITAL_CONT_ANEX_OTROS
            ['tipo' => 'archivo_dig_cont_anex_otros', 'nombre' => 'Actualizado', 'color' => 'success', 'orden' => 1],
            ['tipo' => 'archivo_dig_cont_anex_otros', 'nombre' => 'No Actualizado', 'color' => 'success', 'orden' => 2],
            ['tipo' => 'archivo_dig_cont_anex_otros', 'nombre' => 'Sin Movimiento', 'color' => 'success', 'orden' => 3],
            ['tipo' => 'archivo_dig_cont_anex_otros', 'nombre' => 'No Aplica', 'color' => 'success', 'orden' => 4],
        ];

        DB::table('estados')->insert($estados);
    }

    public function down(): void
    {
        Schema::dropIfExists('estados');
    }
};
