<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'perfil_id',
        'cargo',
        'telefono',
        'activo',
        'ultimo_acceso',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'activo' => 'boolean',
        'ultimo_acceso' => 'datetime',
    ];

    /**
     * Relación con perfil
     */
    public function perfil(): BelongsTo
    {
        return $this->belongsTo(Perfil::class);
    }
    
    /**
     * Verificar si tiene acceso a un módulo
     */
    public function tieneAccesoModulo(string $modulo): bool
    {
        return $this->perfil?->tieneAccesoModulo($modulo) ?? false;
    }
    
    /**
     * Verificar si puede realizar acción en módulo
     */
    public function puedeEnModulo(string $modulo, string $accion): bool
    {
        return $this->perfil?->puedeEnModulo($modulo, $accion) ?? false;
    }
    
    /**
     * Verificar si es super admin
     */
    public function esSuperAdmin(): bool
    {
        return $this->perfil?->nombre === 'Super Admin';
    }
}
