<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PerfilModulo extends Model
{
    protected $table = 'perfil_modulos';
    
    protected $fillable = [
        'perfil_id',
        'modulo',
        'tiene_acceso',
        'puede_ver',
        'puede_crear',
        'puede_editar',
        'puede_eliminar',
    ];

    protected $casts = [
        'tiene_acceso' => 'boolean',
        'puede_ver' => 'boolean',
        'puede_crear' => 'boolean',
        'puede_editar' => 'boolean',
        'puede_eliminar' => 'boolean',
    ];

    /**
     * Relación con perfil
     */
    public function perfil(): BelongsTo
    {
        return $this->belongsTo(Perfil::class);
    }
}
