<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PerfilCampoPermiso extends Model
{
    protected $table = 'perfil_campo_permisos';
    
    protected $fillable = [
        'perfil_id',
        'modulo',
        'campo',
        'puede_ver',
        'puede_editar',
        'puede_crear',
        'puede_eliminar',
    ];

    protected $casts = [
        'puede_ver' => 'boolean',
        'puede_editar' => 'boolean',
        'puede_crear' => 'boolean',
        'puede_eliminar' => 'boolean',
    ];

    /**
     * Relación con perfil
     */
    public function perfil(): BelongsTo
    {
        return $this->belongsTo(Perfil::class);
    }
}
