<?php

namespace App\Filament\Resources\PerfilResource\Pages;

use App\Filament\Resources\PerfilResource;
use App\Models\PerfilModulo;
use Filament\Resources\Pages\CreateRecord;

class CreatePerfil extends CreateRecord
{
    protected static string $resource = PerfilResource::class;
    
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
    
    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Extraer permisos de módulos del formulario
        $modulosPermisos = [];
        
        foreach ($data as $key => $value) {
            if (str_starts_with($key, 'modulo_')) {
                $modulosPermisos[$key] = $value;
                unset($data[$key]);
            }
        }
        
        // Guardar temporalmente para usar en afterCreate
        $this->modulosPermisos = $modulosPermisos;
        
        return $data;
    }
    
    protected function afterCreate(): void
    {
        $perfil = $this->record;
        $modulosPermisos = $this->modulosPermisos ?? [];
        
        // Agrupar por módulo
        $modulos = [];
        foreach ($modulosPermisos as $key => $value) {
            // Ejemplo: modulo_clientes_acceso -> [modulo => clientes, tipo => acceso]
            if (preg_match('/^modulo_(.+)_(acceso|ver|crear|editar|eliminar)$/', $key, $matches)) {
                $moduloNombre = $matches[1];
                $tipoPermiso = $matches[2];
                
                if (!isset($modulos[$moduloNombre])) {
                    $modulos[$moduloNombre] = [
                        'tiene_acceso' => false,
                        'puede_ver' => false,
                        'puede_crear' => false,
                        'puede_editar' => false,
                        'puede_eliminar' => false,
                    ];
                }
                
                if ($tipoPermiso === 'acceso') {
                    $modulos[$moduloNombre]['tiene_acceso'] = (bool) $value;
                } else {
                    $modulos[$moduloNombre]["puede_{$tipoPermiso}"] = (bool) $value;
                }
            }
        }
        
        // Crear registros en perfil_modulos
        foreach ($modulos as $moduloNombre => $permisos) {
            PerfilModulo::create([
                'perfil_id' => $perfil->id,
                'modulo' => $moduloNombre,
                'tiene_acceso' => $permisos['tiene_acceso'],
                'puede_ver' => $permisos['puede_ver'],
                'puede_crear' => $permisos['puede_crear'],
                'puede_editar' => $permisos['puede_editar'],
                'puede_eliminar' => $permisos['puede_eliminar'],
            ]);
        }
    }
}
