<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoSueldos;
use App\Filament\Resources\Estados\Pages\EditEstadoSueldos;

class EstadoSueldosResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Sueldos';
    
    protected static ?string $navigationIcon = 'heroicon-o-currency-dollar';
    
    protected static ?int $navigationSort = 9;
    
    protected static function tipo(): string
    {
        return 'est_sueldos';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoSueldos::route('/'),
            'edit'  => EditEstadoSueldos::route('/{record}/edit'),
        ];
    }
}
