<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoCertificadosLaborales;
use App\Filament\Resources\Estados\Pages\EditEstadoCertificadosLaborales;

class EstadoCertificadosLaboralesResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Certificados Laborales';
    
    protected static ?string $navigationIcon = 'heroicon-o-document-check';
    
    protected static ?int $navigationSort = 10;
    
    protected static function tipo(): string
    {
        return 'certificados_laborales';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoCertificadosLaborales::route('/'),
            'edit'  => EditEstadoCertificadosLaborales::route('/{record}/edit'),
        ];
    }
}
