<?php

namespace App\Filament\Resources\ControlGestionMensualResource\Pages;

use App\Filament\Resources\ControlGestionMensualResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditControlGestionMensual extends EditRecord
{
    protected static string $resource = ControlGestionMensualResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
    
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
    
    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Cargar el cliente con la relación
        $record = $this->getRecord();
        
        // Agregar el RUT de la empresa al formulario
        if ($record->cliente) {
            $data['rut_empresa_display'] = $record->cliente->rut_empresa;
        }
        
        return $data;
    }
}
