<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('control_gestion_mensual', function (Blueprint $table) {
            $table->id();
            
            // Relaciones principales
            $table->foreignId('cliente_id')->nullable()->constrained('clientes')->onDelete('cascade');
            $table->foreignId('grupo_empresa_id')->nullable()->constrained('grupos_empresa')->onDelete('set null');
            
            // Periodo
            $table->string('periodo')->comment('Formato MM-YYYY');
            
            // Relaciones con Estados (15 campos) - Con nombres de constraint cortos
            $table->foreignId('compras_ventas_id')->nullable()->constrained('estados', indexName: 'cgm_compras_ventas_fk')->onDelete('set null');
            $table->foreignId('formulario_29_id')->nullable()->constrained('estados', indexName: 'cgm_formulario_29_fk')->onDelete('set null');
            $table->foreignId('centralizacion_impuesto_id')->nullable()->constrained('estados', indexName: 'cgm_centralizacion_fk')->onDelete('set null');
            $table->foreignId('est_sueldos_id')->nullable()->constrained('estados', indexName: 'cgm_sueldos_fk')->onDelete('set null');
            $table->foreignId('imposiciones_previsionales_id')->nullable()->constrained('estados', indexName: 'cgm_imposiciones_fk')->onDelete('set null');
            $table->foreignId('certificados_laborales_id')->nullable()->constrained('estados', indexName: 'cgm_certificados_fk')->onDelete('set null');
            $table->foreignId('libro_electronico_remuneraciones_id')->nullable()->constrained('estados', indexName: 'cgm_lre_fk')->onDelete('set null');
            $table->foreignId('despidos_mes_id')->nullable()->constrained('estados', indexName: 'cgm_despidos_fk')->onDelete('set null');
            $table->foreignId('registro_electronico_dt_id')->nullable()->constrained('estados', indexName: 'cgm_reg_dt_fk')->onDelete('set null');
            $table->foreignId('archivo_dig_cont_anex_otros_id')->nullable()->constrained('estados', indexName: 'cgm_archivo_fk')->onDelete('set null');
            $table->foreignId('mora_presuntas_id')->nullable()->constrained('estados', indexName: 'cgm_mora_fk')->onDelete('set null');
            $table->foreignId('deudas_fiscales_id')->nullable()->constrained('estados', indexName: 'cgm_deudas_fk')->onDelete('set null');
            $table->foreignId('conciliacion_bancaria_id')->nullable()->constrained('estados', indexName: 'cgm_conciliacion_fk')->onDelete('set null');
            $table->foreignId('balance_mensual_id')->nullable()->constrained('estados', indexName: 'cgm_balance_fk')->onDelete('set null');
            $table->foreignId('analisis_cuentas_id')->nullable()->constrained('estados', indexName: 'cgm_analisis_fk')->onDelete('set null');
            
            // Campos nuevos - Formulario 29
            $table->string('folio_cm')->nullable();
            $table->decimal('monto_peso_cm', 15, 0)->nullable()->default(0);
            $table->string('fecha_venc_form29_cm')->nullable();
            $table->string('fecha_declara_en_plazo_cm')->nullable();
            $table->string('fecha_pago_f_p_cm')->nullable();
            $table->decimal('multa_acum_clp_cm', 15, 0)->nullable()->default(0);
            $table->decimal('total_pagado_clp_cm', 15, 0)->nullable()->default(0);
            
            // Campos nuevos - IVA Posterior
            $table->decimal('iva_post_clp_cm', 15, 0)->nullable()->default(0);
            $table->string('fecha_venc_iva_post_cm')->nullable();
            $table->string('fecha_pago_iva_post_cm')->nullable();
            $table->decimal('multa_iva_post_clp_cm', 15, 0)->nullable()->default(0);
            
            // Campos nuevos - Horas Compra/Venta
            $table->string('hh_compra_venta_iva_cm')->nullable();
            
            // Campos nuevos - Imposiciones
            $table->decimal('monto_impo_cm', 15, 0)->nullable()->default(0);
            $table->string('fecha_venc_impo_cm')->nullable();
            $table->string('fecha_pago_impo')->nullable();
            $table->decimal('multa_impo_clp_cm', 15, 0)->nullable()->default(0);
            $table->decimal('total_pagado_clp_impo_cm', 15, 0)->nullable()->default(0);
            $table->string('hh_impo_cm')->nullable();
            
            // Campos nuevos - Horas Deudas
            $table->string('hh_deuda_cm')->nullable();
            
            // Campos nuevos - Horas Banco/Balance
            $table->string('hh_banco_balance_cm')->nullable();
            
            // Campos nuevos - Totales de Horas
            $table->string('total_hh_mes_cm')->nullable();
            $table->string('hh_asignada_mes')->nullable();
            $table->string('diferencia_hh_mes_cm')->nullable();
            
            // Campos nuevos - Valores
            $table->string('valor_servicio_cm')->nullable();
            $table->string('valor_hh_cm')->nullable();
            
            $table->timestamps();
            
            // Índices para mejorar rendimiento
            $table->index('periodo');
            $table->index(['cliente_id', 'periodo']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('control_gestion_mensual');
    }
};
