<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->foreignId('banco_id_2')->nullable()->after('clave_us_banco')->constrained('bancos')->nullOnDelete();
            $table->string('numero_cuenta_2')->nullable()->after('banco_id_2');
            $table->enum('tipo_ingreso_banco_2', ['web', 'api', 'archivo', 'manual'])->nullable()->after('numero_cuenta_2');
            $table->string('usuario_banco_2')->nullable()->after('tipo_ingreso_banco_2');
            $table->text('clave_us_banco_2')->nullable()->after('usuario_banco_2');
        });
    }

    public function down(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropForeign(['banco_id_2']);
            $table->dropColumn(['banco_id_2', 'numero_cuenta_2', 'tipo_ingreso_banco_2', 'usuario_banco_2', 'clave_us_banco_2']);
        });
    }
};
