<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('estados', function (Blueprint $table) {
            // Hacer tipo nullable temporalmente
            $table->string('tipo')->nullable()->change();
            
            // Agregar la nueva columna
            $table->foreignId('tipo_estado_id')
                ->nullable()
                ->after('parent_id')
                ->constrained('tipos_estado')
                ->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('estados', function (Blueprint $table) {
            $table->dropForeign(['tipo_estado_id']);
            $table->dropColumn('tipo_estado_id');
            $table->string('tipo')->nullable(false)->change();
        });
    }
};
