<?php

namespace App\Filament\Resources\ReporteControlMensualResource\Pages;

use App\Filament\Resources\ReporteControlMensualResource;
use App\Models\ControlGestionMensual;
use App\Models\Cliente;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Facades\DB;

class ListReporteControlMensuals extends ListRecords
{
    protected static string $resource = ReporteControlMensualResource::class;
    
    protected static string $view = 'filament.resources.reporte-control-mensual.pages.list-reporte-control-mensuals';

    protected function getHeaderActions(): array
    {
        return [];
    }
    
    protected function getViewData(): array
    {
        return [
            'aniosDisponibles' => $this->getAniosDisponibles(),
            'periodosDisponibles' => $this->getPeriodosDisponibles(),
            'clientesDisponibles' => $this->getClientesDisponibles(),
        ];
    }
    
    /**
     * Obtener años disponibles desde los registros
     */
    protected function getAniosDisponibles(): array
    {
        $periodos = ControlGestionMensual::select('periodo')
            ->distinct()
            ->pluck('periodo')
            ->map(function($periodo) {
                return substr($periodo, 3, 4); // Extraer año de "MM-YYYY"
            })
            ->unique()
            ->sort()
            ->values()
            ->toArray();
            
        return $periodos;
    }
    
    /**
     * Obtener todos los periodos disponibles
     */
    protected function getPeriodosDisponibles(): array
    {
        return ControlGestionMensual::select('periodo')
            ->distinct()
            ->orderBy('periodo', 'desc')
            ->pluck('periodo')
            ->toArray();
    }
    
    /**
     * Obtener clientes que tienen registros
     */
    protected function getClientesDisponibles()
    {
        return Cliente::whereHas('controlGestionMensual')
            ->where('activo', true)
            ->orderBy('nombre_empresa')
            ->get(['id', 'nombre_empresa', 'rut_empresa']);
    }
}
