<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoDespidosMes;
use App\Filament\Resources\Estados\Pages\EditEstadoDespidosMes;

class EstadoDespidosMesResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Despidos del Mes';
    
    protected static ?string $navigationIcon = 'heroicon-o-user-minus';
    
    protected static ?int $navigationSort = 13;
    
    protected static function tipo(): string
    {
        return 'despidos_mes';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoDespidosMes::route('/'),
            'edit'  => EditEstadoDespidosMes::route('/{record}/edit'),
        ];
    }
}
