<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->foreignId('banco_id_3')->nullable()->after('clave_us_banco_2')->constrained('bancos')->nullOnDelete();
            $table->string('numero_cuenta_3')->nullable()->after('banco_id_3');
            $table->enum('tipo_ingreso_banco_3', ['web', 'api', 'archivo', 'manual'])->nullable()->after('numero_cuenta_3');
            $table->string('usuario_banco_3')->nullable()->after('tipo_ingreso_banco_3');
            $table->text('clave_us_banco_3')->nullable()->after('usuario_banco_3');
        });
    }

    public function down(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropForeign(['banco_id_3']);
            $table->dropColumn(['banco_id_3', 'numero_cuenta_3', 'tipo_ingreso_banco_3', 'usuario_banco_3', 'clave_us_banco_3']);
        });
    }
};
