<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cliente_banco', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cliente_id')->constrained('clientes')->cascadeOnDelete();
            $table->foreignId('banco_id')->constrained('bancos')->cascadeOnDelete();
            $table->string('numero_cuenta')->nullable();
            $table->enum('tipo_ingreso', ['web', 'api', 'archivo', 'manual'])->nullable();
            $table->string('usuario')->nullable();
            $table->text('clave')->nullable(); // Encriptado
            $table->boolean('principal')->default(false);
            $table->timestamps();
            
            $table->unique(['cliente_id', 'banco_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cliente_banco');
    }
};
