<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class Modulo extends Model
{
    protected $fillable = [
        'nombre',
        'slug',
        'descripcion',
        'orden',
        'activo',
    ];

    protected $casts = [
        'activo' => 'boolean',
    ];

    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($modulo) {
            if (empty($modulo->slug)) {
                $modulo->slug = Str::slug($modulo->nombre);
            }
        });
        
        static::updating(function ($modulo) {
            if ($modulo->isDirty('nombre') && empty($modulo->slug)) {
                $modulo->slug = Str::slug($modulo->nombre);
            }
        });
    }

    public function tiposEstado(): HasMany
    {
        return $this->hasMany(TipoEstado::class)->orderBy('orden');
    }
}
