<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Crypt;

class Cliente extends Model
{
    protected $fillable = [
        'grupo_empresa_id',
        'nombre_empresa',
        'rut_empresa',
        'nombre_rep',
        'rut_rep',
        'direccion_emp',
        'software_id',
        'nom_en_sw',
        'usuario_sw_main',
        'clave_sw_main',
        'rut_sii',
        'clave_sii',
        'rut_sii_empresa',
        'clave_sii_empresa',
        'clave_unica',
        'usuario_previred',
        'clave_previred',
        'clave_dt',
        'usuario_defontana',
        'clave_defontana',
        'usuario_nubox',
        'clave_nubox',
        'banco_id',
        'numero_cuenta',
        'tipo_ingreso_banco',
        'usuario_banco',
        'clave_us_banco',
        'banco_id_2',
        'numero_cuenta_2',
        'tipo_ingreso_banco_2',
        'usuario_banco_2',
        'clave_us_banco_2',
        'banco_id_3',
        'numero_cuenta_3',
        'tipo_ingreso_banco_3',
        'usuario_banco_3',
        'clave_us_banco_3',
        'activo',
    ];

    protected $casts = [
        'activo' => 'boolean',
    ];

    // Encriptar automáticamente las claves
    protected static function boot()
    {
        parent::boot();
        
        static::saving(function ($cliente) {
            $camposEncriptar = [
                'clave_sw_main',
                'clave_sii',
                'clave_sii_empresa',
                'clave_unica',
                'clave_previred',
                'clave_dt',
                'clave_defontana',
                'clave_nubox',
                'clave_us_banco',
                'clave_us_banco_2',
                'clave_us_banco_3',
            ];
            
            foreach ($camposEncriptar as $campo) {
                if ($cliente->isDirty($campo) && !empty($cliente->$campo)) {
                    try {
                        Crypt::decryptString($cliente->$campo);
                    } catch (\Exception $e) {
                        $cliente->$campo = Crypt::encryptString($cliente->$campo);
                    }
                }
            }
        });
    }

    // Relaciones
    public function grupoEmpresa(): BelongsTo
    {
        return $this->belongsTo(GrupoEmpresa::class);
    }

    public function software(): BelongsTo
    {
        return $this->belongsTo(Software::class);
    }

    public function banco(): BelongsTo
    {
        return $this->belongsTo(Banco::class, 'banco_id');
    }

    public function banco2(): BelongsTo
    {
        return $this->belongsTo(Banco::class, 'banco_id_2');
    }

    public function banco3(): BelongsTo
    {
        return $this->belongsTo(Banco::class, 'banco_id_3');
    }
}
