<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoBalanceMensual;
use App\Filament\Resources\Estados\Pages\EditEstadoBalanceMensual;

class EstadoBalanceMensualResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Balance Mensual';
    
    protected static ?string $navigationIcon = 'heroicon-o-scale';
    
    protected static ?int $navigationSort = 6;
    
    protected static function tipo(): string
    {
        return 'balance_mensual';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoBalanceMensual::route('/'),
            'edit'  => EditEstadoBalanceMensual::route('/{record}/edit'),
        ];
    }
}
