<?php

namespace App\Filament\Resources\TipoEstadoResource\Pages;

use App\Filament\Resources\TipoEstadoResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditTipoEstado extends EditRecord
{
    protected static string $resource = TipoEstadoResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
    
    protected function getRedirectUrl(): string
    {
        // Redirigir a la página de edición del módulo padre
        $moduloId = $this->record->modulo_id;
        return route('filament.admin.resources.modulos.edit', ['record' => $moduloId]);
    }
}
