<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoMoraPresuntas;
use App\Filament\Resources\Estados\Pages\EditEstadoMoraPresuntas;

class EstadoMoraPresuntasResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Mora Presuntas';
    
    protected static ?string $navigationIcon = 'heroicon-o-clock';
    
    protected static ?int $navigationSort = 8;
    
    protected static function tipo(): string
    {
        return 'mora_presuntas';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoMoraPresuntas::route('/'),
            'edit'  => EditEstadoMoraPresuntas::route('/{record}/edit'),
        ];
    }
}
