<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoAnalisisCuentas;
use App\Filament\Resources\Estados\Pages\EditEstadoAnalisisCuentas;

class EstadoAnalisisCuentasResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Análisis de Cuentas';
    
    protected static ?string $navigationIcon = 'heroicon-o-chart-bar';
    
    protected static ?int $navigationSort = 7;
    
    protected static function tipo(): string
    {
        return 'analisis_cuentas';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoAnalisisCuentas::route('/'),
            'edit'  => EditEstadoAnalisisCuentas::route('/{record}/edit'),
        ];
    }
}
