<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->foreignId('banco_id')->nullable()->constrained('bancos')->nullOnDelete();
            $table->enum('tipo_ingreso_banco', ['web', 'api', 'archivo', 'manual'])->nullable();
            $table->string('usuario_banco')->nullable();
            $table->text('clave_us_banco')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropForeign(['banco_id']);
            $table->dropColumn(['banco_id', 'tipo_ingreso_banco', 'usuario_banco', 'clave_us_banco']);
        });
    }
};
