<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoRegistroElectronicoDt;
use App\Filament\Resources\Estados\Pages\EditEstadoRegistroElectronicoDt;

class EstadoRegistroElectronicoDtResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Registro Electrónico DT';
    
    protected static ?string $navigationIcon = 'heroicon-o-clipboard-document-list';
    
    protected static ?int $navigationSort = 14;
    
    protected static function tipo(): string
    {
        return 'registro_electronico_dt';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoRegistroElectronicoDt::route('/'),
            'edit'  => EditEstadoRegistroElectronicoDt::route('/{record}/edit'),
        ];
    }
}
