<?php

namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoComprasVentas;
use App\Filament\Resources\Estados\Pages\EditEstadoComprasVentas;


class EstadoComprasVentasResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Compras y Ventas';
    protected static ?string $navigationIcon = 'heroicon-o-shopping-cart';
    protected static ?int $navigationSort = 1;

    protected static function tipo(): string
    {
        return 'compras_ventas';
    }

    public static function getPages(): array
{
    return [
        'index' => ListEstadoComprasVentas::route('/'),
        'edit'  => EditEstadoComprasVentas::route('/{record}/edit'),
    ];
    }
}
