<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoArchivoDigital;
use App\Filament\Resources\Estados\Pages\EditEstadoArchivoDigital;

class EstadoArchivoDigitalResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Archivo Digital';
    
    protected static ?string $navigationIcon = 'heroicon-o-archive-box';
    
    protected static ?int $navigationSort = 15;
    
    protected static function tipo(): string
    {
        return 'archivo_dig_cont_anex_otros';
    }
    
    public static function getPages(): array
    {
        return [
            'index' => ListEstadoArchivoDigital::route('/'),
            'edit'  => EditEstadoArchivoDigital::route('/{record}/edit'),
        ];
    }
}
