<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Estado extends Model
{
    protected $fillable = [
        'tipo_estado_id',
        'parent_id',
        'tipo',
        'nombre',
        'color',
        'orden',
        'activo',
    ];

    protected $casts = [
        'activo' => 'boolean',
    ];

    public function tipoEstado(): BelongsTo
    {
        return $this->belongsTo(TipoEstado::class);
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(Estado::class, 'parent_id')->orderBy('orden');
    }

    public function scopePadres($query)
    {
        return $query->whereNull('parent_id');
    }

    public function scopeHijos($query)
    {
        return $query->whereNotNull('parent_id');
    }
}
