<?php
namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoDeudasFiscalesInformadas;
use App\Filament\Resources\Estados\Pages\EditEstadoDeudasFiscalesInformadas;

class EstadoDeudasFiscalesInformadasResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Deudas Fiscales';

    protected static ?string $navigationIcon = 'heroicon-o-exclamation-triangle';

    protected static ?int $navigationSort = 4;

    protected static function tipo(): string
    {
        return 'deudas_fiscales'; // ✅ Cambiado de 'deudas_fiscales_informadas' a 'deudas_fiscales'
    }

    public static function getPages(): array
    {
        return [
            'index' => ListEstadoDeudasFiscalesInformadas::route('/'),
            'edit'  => EditEstadoDeudasFiscalesInformadas::route('/{record}/edit'),
        ];
    }
}
