<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->string('rut_sii_empresa')->nullable()->after('rut_sii');
            $table->text('clave_sii_empresa')->nullable()->after('clave_sii');
        });
    }

    public function down(): void
    {
        Schema::table('clientes', function (Blueprint $table) {
            $table->dropColumn(['rut_sii_empresa', 'clave_sii_empresa']);
        });
    }
};
