<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Crypt;

class Cliente extends Model
{
    protected $fillable = [
        'grupo_empresa_id',
        'nombre_empresa',
        'rut_empresa',
        'nombre_rep',
        'rut_rep',
        'direccion_emp',
        'software_id',
        'nom_en_sw',
        'usuario_sw_main',
        'clave_sw_main',
        'rut_sii',
        'clave_sii',
        'clave_unica',
        'usuario_previred',
        'clave_previred',
        'clave_dt',
        'usuario_defontana',
        'clave_defontana',
        'usuario_nubox',
        'clave_nubox',
        'banco_id',
        'numero_cuenta',
        'tipo_ingreso_banco',
        'usuario_banco',
        'clave_us_banco',
        'activo',
    ];

    protected $casts = [
        'activo' => 'boolean',
    ];

    // Encriptar automáticamente las claves
    protected static function boot()
    {
        parent::boot();
        
        static::saving(function ($cliente) {
            $camposEncriptar = [
                'clave_sw_main',
                'clave_sii',
                'clave_unica',
                'clave_previred',
                'clave_dt',
                'clave_defontana',
                'clave_nubox',
                'clave_us_banco',
            ];
            
            foreach ($camposEncriptar as $campo) {
                if ($cliente->isDirty($campo) && !empty($cliente->$campo)) {
                    try {
                        Crypt::decryptString($cliente->$campo);
                    } catch (\Exception $e) {
                        $cliente->$campo = Crypt::encryptString($cliente->$campo);
                    }
                }
            }
        });
    }

    // Relaciones
    public function grupoEmpresa(): BelongsTo
    {
        return $this->belongsTo(GrupoEmpresa::class);
    }

    public function software(): BelongsTo
    {
        return $this->belongsTo(Software::class);
    }

    public function banco(): BelongsTo
    {
        return $this->belongsTo(Banco::class);
    }
}
