<?php

namespace App\Filament\Resources\ClienteResource\Pages;

use App\Filament\Resources\ClienteResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Crypt;

class EditCliente extends EditRecord
{
    protected static string $resource = ClienteResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
    
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
    
    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Desencriptar las contraseñas para mostrarlas en el formulario
        $camposEncriptados = [
            'clave_sw_main',
            'clave_sii',
            'clave_sii_empresa',
            'clave_unica',
            'clave_previred',
            'clave_dt',
            'clave_defontana',
            'clave_nubox',
            'clave_us_banco',
        ];
        
        foreach ($camposEncriptados as $campo) {
            if (!empty($data[$campo])) {
                try {
                    $data[$campo] = Crypt::decryptString($data[$campo]);
                } catch (\Exception $e) {
                    // Si falla la desencriptación, dejar el valor como está
                }
            }
        }
        
        return $data;
    }
}
