<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect('/admin');
});

Route::get('/test-session', function () {
    return response()->json([
        'session_works' => session()->getId(),
        'csrf_token' => csrf_token(),
        'config_url' => config('app.url'),
        'user' => auth()->check() ? auth()->user()->email : 'not authenticated'
    ]);
});
Route::middleware(['web', 'auth'])->get('/test-auth', function () {
    return 'Auth works! User: ' . auth()->user()->email;
});

Route::get('/livewire-test', \App\Livewire\TestComponent::class)->middleware('auth');
