<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Estado extends Model
{
    protected $fillable = [
        'parent_id',
        'tipo',
        'nombre',
        'color',
        'orden',
        'activo',
    ];

    protected $casts = [
        'activo' => 'boolean',
    ];

    // Relación: Estado padre
    public function parent(): BelongsTo
    {
        return $this->belongsTo(Estado::class, 'parent_id');
    }

    // Relación: Estados hijos
    public function children(): HasMany
    {
        return $this->hasMany(Estado::class, 'parent_id')->orderBy('orden');
    }

    // Scope para obtener solo estados padre (sin parent_id)
    public function scopePadres($query)
    {
        return $query->whereNull('parent_id');
    }

    // Scope para obtener solo estados hijo (con parent_id)
    public function scopeHijos($query)
    {
        return $query->whereNotNull('parent_id');
    }
}
