<?php

namespace App\Filament\Resources\Estados;

use App\Filament\Resources\Estados\Pages\ListEstadoCentralizacionImpuesto;
use App\Filament\Resources\Estados\Pages\EditEstadoCentralizacionImpuesto;

class EstadoCentralizacionImpuestoResource extends BaseEstadoPorTipoResource
{
    protected static ?string $navigationLabel = 'Centralización Impuesto';
    protected static ?string $navigationIcon = 'heroicon-o-banknotes';
    protected static ?int $navigationSort = 3;

    protected static function tipo(): string
    {
        return 'centralizacion_impuesto';
    }

    public static function getPages(): array
    {
        return [
            'index' => ListEstadoCentralizacionImpuesto::route('/'),
            'edit'  => EditEstadoCentralizacionImpuesto::route('/{record}/edit'),
        ];
    }
}
