<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Estado extends Model
{
    protected $fillable = ['tipo', 'nombre', 'color', 'orden', 'activo'];
    
    protected $casts = [
        'activo' => 'boolean',
    ];
    
    public function scopeTipo($query, $tipo)
    {
        return $query->where('tipo', $tipo)
                     ->where('activo', true)
                     ->orderBy('orden');
    }
}
